/*
 *                  QLOGIC LINUX SOFTWARE
 *
 * QLogic ISP2x00 device driver for Linux 2.6.x
 * Copyright (C) 2003-2005 QLogic Corporation
 * (www.qlogic.com)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/string.h>

/*
 * Extended configuration parameters
 */
#include "qla_opts.h"

MODULE_DESCRIPTION("QLogic Persistent Binding Data Module");
MODULE_AUTHOR("QLogic Corporation");
MODULE_LICENSE("GPL");

char *qla_persistent_str = NULL ;
CONFIG_BEGIN("qla2xxx_conf")
CONFIG_ITEM("OPTIONS", "")
CONFIG_END

static int conf_init(void)
{
	QLOPTS_CONFIGURE(qla_persistent_str);
	inter_module_register("qla2xxx_conf", THIS_MODULE, qla_persistent_str);
	return 0;
}

static void conf_exit (void)
{
	inter_module_unregister("qla2xxx_conf");
}

module_init(conf_init);
module_exit(conf_exit);


